using JLD2, Printf, StatsPlots, ArgParse;

include("runit.jl");
include("helpers_experiments.jl");
include("helpers.jl");

function parse_commandline()
    s = ArgParseSettings();

    @add_arg_table! s begin
        "--exp_dir"
            help = "Directory for loading the experiment's data, while saving the plots in the corresponding folder."
            arg_type = String
            default = "experiments/"
        "--format"
            help = "Format to save the figures."
            arg_type = String
            default = "pdf"
    end

    parse_args(s);
end

parsed_args = parse_commandline();
exp_dir = parsed_args["exp_dir"];
format = parsed_args["format"];

experiments = filter(x -> isdir("$(exp_dir)$x") && occursin("_random_", x), readdir(exp_dir));
for experiment in experiments
    # Check for existing plots in the corresponding format
    existing_plots = length(filter(x -> occursin(".$format", x), readdir("$(exp_dir)$(experiment)/"))) != 0;

    if ! existing_plots
        println("Creating plots in .$format based on $(exp_dir)$(experiment) ...");

        name_experiment = split(experiment, ":")[2];
        @load "$(exp_dir)$(experiment)/$(name_experiment).dat" iss data iss_index δs param_inst Nruns seed;

        delta = split(string(δs[1]), ".")[2];

        # Plot the sample complexity per learner in a boxplot fashion
        file_plot_charactimes = "$(exp_dir)$(experiment)/plot_charac_times_$(name_experiment).$format";
        file_plot_allocbest = "$(exp_dir)$(experiment)/plot_alloc_best_$(name_experiment).$format";
        plot_instances_dists(data, iss, iss_index, file_plot_charactimes, file_plot_allocbest);

        # Top Two vs Benchmarks
        iss_to_keep = ["cst-UCBI-TC-T-G-GK16", "cst-EB-TCI-G-GK16", "cst-TS-TC-G-GK16", "cst-TS-RS-G-GK16",
                       "TaS-C-G-GK16", "FWS-C-G-GK16", "DKM-C-G-GK16", "LUCB-G-GK16", "LUCBhalf-G-GK16", "RR-G-GK16"];
        name_iss = ["TTUCB", "EB-TCI", "T3C", "TTTS", "TaS", "FWS", "DKM", "LUCB", "1/2-LUCB", "Uniform"];
        file_plot_samp = "$(exp_dir)$(experiment)/plot_samp_tvb_$(name_experiment)_delta$(delta).$format";
        plot_rand_samp(iss, data, iss_index, Nruns, file_plot_samp, iss_to_keep, name_iss);

        file_plot_perror = "$(exp_dir)$(experiment)/plot_perror_tvb_$(name_experiment)_delta$(delta).$format";
        plot_rand_perror(iss, data, iss_index, Nruns, file_plot_perror, iss_to_keep, name_iss);

        file_plot_samp = "$(exp_dir)$(experiment)/plot_cput_tvb_$(name_experiment)_delta$(delta).$format";
        plot_rand_cput(iss, data, iss_index, Nruns, file_plot_samp, iss_to_keep, name_iss);

        # Constant vs Adaptive
        iss_to_keep = ["cst-UCBI-TC-T-G-GK16", "BC-UCBI-TC-T-G-GK16",
                       "cst-EB-TCI-G-GK16", "BC-EB-TCI-G-GK16",
                       "cst-TS-TC-G-GK16", "BC-TS-TC-G-GK16",
                       "cst-TS-RS-G-GK16", "BC-TS-RS-G-GK16"];
        name_iss = ["TTUCB", "A-TTUCB", "EB-TCI", "A-EB-TCI", "T3C", "A-T3C", "TTTS", "A-TTTS"];
        file_plot_samp = "$(exp_dir)$(experiment)/plot_samp_cva_$(name_experiment)_delta$(delta).$format";
        plot_rand_samp(iss, data, iss_index, Nruns, file_plot_samp, iss_to_keep, name_iss);

        # Tracking vs Sampling
        iss_to_keep = ["cst-UCBI-TC-T-G-GK16", "cst-UCBI-TC-G-GK16",
                       "cst-EB-TCI-T-G-GK16", "cst-EB-TCI-G-GK16",
                       "cst-TS-TC-T-G-GK16", "cst-TS-TC-G-GK16",
                       "cst-TS-RS-T-G-GK16", "cst-TS-RS-G-GK16"];
        name_iss = ["TTUCB", "S-TTUCB", "T-EB-TCI", "EB-TCI", "T-T3C", "T3C", "T-TTTS", "TTTS"];
        file_plot_samp = "$(exp_dir)$(experiment)/plot_samp_tvs_$(name_experiment)_delta$(delta).$format";
        plot_rand_samp(iss, data, iss_index, Nruns, file_plot_samp, iss_to_keep, name_iss);

        # Different level of penalization
        iss_to_keep = ["cst-EB-TCI-T-G-GK16", "cst-EB-TCIs+-T-G-GK16", "cst-EB-TCIs-T-G-GK16", "cst-EB-TCIsp+-T-G-GK16", "cst-EB-TCIsp-T-G-GK16"];
        name_iss = ["Original", "κ = 1.2", "κ = 2", "α = 2", "α = 1.2"];
        file_plot_samp = "$(exp_dir)$(experiment)/plot_samp_TCI_$(name_experiment)_delta$(delta).$format";
        plot_rand_samp(iss, data, iss_index, Nruns, file_plot_samp, iss_to_keep, name_iss);

        file_plot_perror = "$(exp_dir)$(experiment)/plot_perror_TCI_$(name_experiment)_delta$(delta).$format";
        plot_rand_perror(iss, data, iss_index, Nruns, file_plot_perror, iss_to_keep, name_iss);

    else
        println("Plots in .$format based on $(exp_dir)$(experiment) already exist.");
    end
    println("");
end
