# Non-Asymptotic Analysis of a UCB-based Top Two Algorithm

The general structure of the code (and some functions) is taken from [this library](https://bitbucket.org/wmkoolen/tidnabbil/src/master/). References to the papers of the authors of this library are already included in the paper.

## Setting up the environment

**Download Anaconda**
```
wget https://repo.continuum.io/archive/Anaconda3-2021.05-Linux-x86_64.sh
sha256sum Anaconda3-2021.05-Linux-x86_64.sh
bash Anaconda3-2021.05-Linux-x86_64.sh
```

**Create environment**
```
conda create --name julia-env
conda activate julia-env
conda install -c conda-forge julia
```

**Download packages**
```
julia
using Pkg;
Pkg.add(["JLD2", "Printf", "JSON", "Dates", "IterTools", "Distributed", "JuMP", "Tulip",
         "Random", "LinearAlgebra", "Distributions", "Combinatorics", "CPUTime",
         "StatsPlots", "ArgParse", "Statistics", "StatsBase", "Plots",
         "Pickle", "ColorSchemes"]);
```

## Experiments

After installing Julia, to run the experiments presented in the paper, you can either use the custom commands (defined below) to only perform a given experiment or you can directly run the `script.sh`. Some experiments are computationally costly, hence we recommend to use more cores than solely four (`-p4`), or to reduce the number of runs (`--Nruns 100`).

```
cd path_to_folder/code
cd adatoptwo
mkdir experiments
mkdir simulations
mkdir data
```

### All experiments at once

To run our script with four cores:
```
chmod +x script.sh
bash script.sh 4
```
Note that the script doesn't include the plotting functions. Therefore, additional runs of the corresponding plotting functionalities have to be made afterwards (see below). As it is, you might need to be careful in the order in which you call the visualization functions since the plots are created for all the folders in the `experiments` folder, which don't have `.pdf` inside them.

### One at a time

#### Simulations

```
cd path_to_folder/code/adatoptwo
julia -O3 -p4 adatt_simulations.jl --seed 42 --Nruns 1000
julia adatt_viz_simulations.jl
```

#### Random

```
cd path_to_folder/code/adatoptwo
julia -O3 -p4 adatt_randoms.jl --expe "random" --inst "uniform" --mu1 0.6 --gapmin 0.1 --gapmax 0.4 --K 10 --seed 42 --Nruns 5000
julia -O3 -p4 adatt_randoms.jl --expe "random" --inst "unif2G" --K 10 --seed 42 --Nruns 5000
julia adatt_viz_random.jl
```

#### Equal means

```
cd path_to_folder/code/adatoptwo
julia -O3 -p4 adatt_experiments.jl --expe "fastAdapt" --inst "eqgapE" --K 35 --seed 42 --Nruns 5000
julia adatt_viz_experiments.jl
```

#### Larger Sets of Arms

`1-sparse` benchmark
```
cd path_to_folder/code/adatoptwo
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "sparse" --K 10 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "sparse" --K 50 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "sparse" --K 100 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "sparse" --K 250 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "sparse" --K 500 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "sparse" --K 750 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "sparse" --K 1000 --seed 42 --Nruns 100
```

`α=0.3` benchmark
```
cd path_to_folder/code/adatoptwo
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha3" --K 10 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha3" --K 50 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha3" --K 100 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha3" --K 250 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha3" --K 500 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha3" --K 750 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha3" --K 1000 --seed 42 --Nruns 100
```

`α=0.6` benchmark
```
cd path_to_folder/code/adatoptwo
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha6" --K 10 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha6" --K 50 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha6" --K 100 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha6" --K 250 --seed 42 --Nruns 100
julia -O3 -p4 adatt_experiments.jl --expe "fast" --inst "alpha6" --K 500 --seed 42 --Nruns 100
```

For the plots on the benchmarks `1-sparse`, `α=0.3` and `α=0.6`, it is necessary to get manually the results from all the runs in the summary file. After filling the lists in the file `plots_large_arms_delta1.jl`, simply run `julia plots_large_arms_delta1.jl`.
