# Functions for implementing FW-Sampling

using JuMP;
import Tulip;

function hμ_in_lambda(hμ, hi, K)
    for i=1:K
        if ((i!=hi) && (hμ[hi]-hμ[i])<=eps())
            return false;
        end
    end
    return true;
end

function is_complete_square(n)
    p = floor(Int, sqrt(n));
    return p*p == n;
end

"""
Solving the LP formulation of mixed-strategy 2-player zero-sum game
"""

function solveZeroSumGame(M_payoff, K, n_row)
    m = Model(Tulip.Optimizer);
    @variable(m, x[1:K] >= 0)
    @variable(m, w)
    for j in 1:n_row
        @constraint(m, sum(M_payoff[j][k]*x[k] for k=1:K) >= w)
    end
    @constraint(m, sum(x[i] for i=1:K) == 1)
    @objective(m, Max, w)
    optimize!(m);
    f_success = termination_status(m);
    z = JuMP.value.(x);
    return z;
end
