#!/bin/bash

#SBATCH --gres=gpu:1
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=8

#SBATCH --job-name=hw_metrics_lm
#SBATCH --open-mode=append  # important for multiple processes to share a log file

#SBATCH --error=<repo path>/slurm_logs/%j_%a_%N_log.err
#SBATCH --output=<repo path>/slurm_logs/%j_%a_%N_log.out

#SBATCH --partition=<partition>
#SBATCH --time=06:00:00  
#SBATCH --mail-type=FAIL
#SBATCH --exclude=<exclude>

# Define the models and batch sizes
# Adjust the array size based on the total number of combinations
# For example, with 6 models and 7 batch sizes, you would need --array=0-41

cd <repo path> || exit 1

source .venv/bin/activate || exit 1

export PYTHONPATH=$PWD
# Define the batch sizes

# Calculate which model and batch size to use based on the array task ID

config_name=$1

# Run the experiment with the new script
python experiments/LMs/hw_metrics/collect_hw_metrics.py \
    --config_name $config_name \
    --num_dataloader_workers 8 \
    --warmup_passes 100

# end of file
