#!/bin/bash

#SBATCH --gres=gpu:8
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=16
#SBATCH --cpus-per-task=4

#SBATCH --job-name=continuation
#SBATCH --open-mode=append

#SBATCH --error=./slurm_logs/%j_%a_%N_log.err
#SBATCH --output=./slurm_logs/%j_%a_%N_log.out

#SBATCH --partition=<partition>
#SBATCH --time=24:00:00 
#SBATCH --mail-type=FAIL

cd <repo path> || exit 1

source .venv/bin/activate || exit 1

export PYTHONPATH=$PWD

if [ -z "$1" ]; then
    echo "Error: group_name argument is required"
    exit 1
fi

group_name=$1
dataset=$2

# Validate dataset parameter
if [ -z "$dataset" ]; then
    echo "Error: dataset argument is required"
    exit 1
fi

if [ "$dataset" != "c10" ] && [ "$dataset" != "c100" ]; then
    echo "Error: dataset must be either 'c10' or 'c100'"
    exit 1
fi


srun --unbuffered \
    --ntasks 16 \
    --gpus-per-task 0.5 \
    --cpus-per-task 4 \
    python experiments/resnet/continuation/continuation.py \
        --group_name $group_name \
        --dataset $dataset \
        --num_dataloader_workers 4

# end of file
