[ -z "${dataset_name}" ] && dataset_name="ogb_lsc"
[ -z "${seed}" ] && seed="8"
[ -z "${train_args}" ] && train_args="\
--batch_size 256 --learning_rate 1e-4 --weight_decay 1e-5 --num_workers 16 --multi_hop_max_dist 5"
[ -z "${model_args}" ] && model_args="\
--d_model 512 --nhead 16 --dim_feedforward 2048 --num_layers 6 --dropout 0.1 \
--pe_type learnable --pe_scale_factor 1.0"
[ -z "${distillation_args}"] && distillation_args="\
--distillation --online_distillation \
--teacher_feature_distillation_layers 9 10 11 \
--student_feature_distillation_layers 3 4 5 \
--teacher_attention_weight_distillation_layers 9 10 11 \
--student_attention_weight_distillation_layers 3 4 5 \
--feature_distillation_loss_weight 0.5 \
--attention_weight_distillation_loss_weight 2.0 \
--warmup_epochs 5 \
--warmup_task_loss_weight 0.0 \
--warmup_feature_distillation_loss_weight 1.0 \
--warmup_attention_weight_distillation_loss_weight 4.0 \
--teacher_checkpoint_save_path ./saved_checkpoints/graphormer_final.ckpt"
[ -z "${trainer_args}" ] && trainer_args="\
--max_epochs 200 --check_val_every_n_epoch 1 \
--gpus 1 --precision 32 --gradient_clip_val 5.0 --save_top_k 5"
[ -z "${visible_gpu}"] && visible_gpu="0"

cd ..
echo -e "\n"
echo "-------------------------------ARGS-------------------------------"
echo "arg0: ${0}"
echo "dataset_name: ${dataset_name}"
echo "seed: ${seed}"
echo "train_args: ${train_args}"
echo "model_args: ${model_args}"
echo "distillation_args: ${distillation_args}"
echo "trainer_args: ${trainer_args}"
echo "visible_gpu: ${visible_gpu}"
echo "------------------------------------------------------------------"


# experiment records file
save_path="./exp_records/${dataset_name}"
mkdir -p ${save_path}
CUDA_VISIBLE_DEVICES=${visible_gpu} \
    python main.py --dataset_name ${dataset_name} \
    ${train_args} ${model_args} ${trainer_args} ${distillation_args} \
    --seed ${seed} \
    --default_root_dir ${save_path} \