[ -z "${dataset_name}" ] && dataset_name="qm8"
[ -z "${seed}" ] && seed="8"
[ -z "${train_args}" ] && train_args="\
--batch_size 80 --learning_rate 1e-4 --weight_decay 1e-5 --num_workers 8"
[ -z "${model_args}" ] && model_args="\
--d_model 512"
[ -z "${finetune_args}"] && finetune_args="\
--finetune \
--finetune_checkpoint_save_path ./saved_checkpoints/STKD_final.ckpt \
--change_dropout 0.0"
[ -z "${trainer_args}" ] && trainer_args="\
--max_epochs 100 --check_val_every_n_epoch 1 \
--gpus 1 --precision 32 --gradient_clip_val 5.0 --save_top_k 5"
[ -z "${visible_gpu}"] && visible_gpu="0"

cd ..
echo -e "\n"
echo "-------------------------------ARGS-------------------------------"
echo "arg0: ${0}"
echo "dataset_name: ${dataset_name}"
echo "seed: ${seed}"
echo "train_args: ${train_args}"
echo "model_args: ${model_args}"
echo "finetune_args: ${distillation_args}"
echo "trainer_args: ${trainer_args}"
echo "visible_gpu: ${visible_gpu}"
echo "------------------------------------------------------------------"

# experiment records file
save_path="./exp_records/${dataset_name}"
mkdir -p ${save_path}
CUDA_VISIBLE_DEVICES=${visible_gpu} \
    python main.py --dataset_name ${dataset_name} \
    ${train_args} ${model_args} ${trainer_args} ${finetune_args} \
    --seed ${seed} \
    --default_root_dir ${save_path} \