if True:  # pragma: no cover

    group = C8() 
    delta = np.pi / 4

    elements = group.elements()

    assert group.size() == 8

    assert torch.allclose(group.elements(), torch.tensor([0., delta, delta * 2, delta * 3, delta * 4, delta * 5, delta * 6, delta * 7]))

    assert torch.allclose(group.product(elements[0], elements[3]), elements[3])
    assert torch.allclose(group.product(elements[3], elements[0]), elements[3])
    assert torch.allclose(group.product(elements[2], elements[3]), elements[5])
    assert torch.allclose(group.product(elements[6], elements[3]), elements[1])
    assert torch.allclose(group.product(elements[4], elements[4]), elements[0])
    assert torch.allclose(group.product(elements[6], elements[6]), elements[4])

    assert torch.allclose(group.inverse(elements[0]), elements[0])
    assert torch.allclose(group.inverse(elements[1]), elements[7])
    assert torch.allclose(group.inverse(elements[2]), elements[6])
    assert torch.allclose(group.inverse(elements[3]), elements[5])
    assert torch.allclose(group.inverse(elements[4]), elements[4])

    assert torch.allclose(group.matrix_representation(elements[0]), torch.tensor([[1.0, 0.0], [0.0, 1.0]]))
    assert torch.allclose(group.matrix_representation(elements[1]), torch.tensor([[0.7071, -0.7071], [0.7071,  0.7071]]))
    assert torch.allclose(group.matrix_representation(elements[2]), torch.tensor([[-4.3711e-08, -1.0000e+00], [1.0000e+00, -4.3711e-08]]))
    assert torch.allclose(group.matrix_representation(elements[3]), torch.tensor([[-0.7071, -0.7071], [ 0.7071, -0.7071]]))
    assert torch.allclose(group.matrix_representation(elements[4]), torch.tensor([[-1.0000e+00,  8.7423e-08], [-8.7423e-08, -1.0000e+00]]))
    assert torch.allclose(group.matrix_representation(elements[5]), torch.tensor([[-0.7071,  0.7071], [-0.7071, -0.7071]]))
    assert torch.allclose(group.matrix_representation(elements[6]), torch.tensor([[1.1925e-08,  1.0000e+00], [-1.0000e+00,  1.1925e-08]]))
    assert torch.allclose(group.matrix_representation(elements[7]), torch.tensor([[0.7071,  0.7071], [-0.7071,  0.7071]]))