if True:  # pragma: no cover
    # Game tests
    gameOver = Game(None, None)
    gameOver.board = [[True, False, True],
                      [False, True, False],
                      [True, False, True]]
    assert gameOver.gameOver()

    player1Won = Game(None, None)
    player1Won.board = [[True, True, True],
                        [True, True, True],
                        [True, True, True]]
    assert player1Won.playerXWon(True)

    player2Won = Game(None, None)

    player2Won.board = [[False, False, False],
                        [False, False, False],
                        [False, False, False]]
    assert player2Won.playerXWon(False)
    downDiag = Game(None, None)
    downDiag.board = [[True, False, False],
                      [False, True, False],
                      [False, False, True]]
    assert downDiag.playerXWon(True)
    upDiag = Game(None, None)
    upDiag.board = [[False, False, True],
                    [False, True, False],
                    [True, False, False]]
    assert upDiag.playerXWon(True)

    cs = CornerStrategy()
    b = [[None for _ in range(3)] for _ in range(3)]
    assert cs.returnMove(b) == (0, 0)
    b[0][0] = True
    assert cs.returnMove(b) == (0, 2)
    b[0][2] = True
    assert cs.returnMove(b) == (2, 0)
    b[2][0] = True
    assert cs.returnMove(b) == (2, 2)
    b[2][2] = True

    try:
        cs.returnMove(b)
    except:
        assert True
    else:
        assert False

    gs = GoodStrategy()
    b = [[None for _ in range(3)] for _ in range(3)]
    try:
        gs.returnMove(b)
        gs.returnMove(b)
        gs.returnMove(b)
        gs.returnMove(b)
    except Exception:
        assert True


    # Did not change Game test
    import inspect

    assert inspect.getsource(Game).strip() == '''class Game:
    def __init__(self, player1: Strategy, player2: Strategy):
        self.playerOne = player1
        self.playerTwo = player2
        self.board = [[None for _ in range(3)] for _ in range(3)]

    def player1Won(self):
        playerTurn = True
        while not self.playerXWon(True) and not self.playerXWon(False) and not self.gameOver():
             strat = self.playerOne if playerTurn else self.playerTwo
             move = strat.returnMove(self.board)
             self.board[move[0]][move[1]] = playerTurn
             playerTurn = not playerTurn
        if self.gameOver():
            return False
        else:
            return self.playerXWon(True)


    def gameOver(self):
        for row in self.board:
            for col in row:
                if col == None:
                    return False
        return True
    
    def playerXWon(self, x: bool):
        for i in range(3):
            if self.rowNX(i, x):
                return True
        for i in range(3):
            if self.colNX(i, x):
                return True
        downDiag = self.board[0][0] == x and self.board[1][1] == x and self.board[2][2] == x
        upDiag = self.board[2][0] == x and self.board[1][1] == x and self.board[0][2] == x
        return downDiag or upDiag
    


    def rowNX(self, n: int, x: bool):
        for col in self.board[n]:
            if col != x:
                return False
        return True
    def colNX(self, n: int, x: bool):
        for row in self.board:
            if row[n] != x:
                return False
        return True'''.strip()

    # Followed prompt test
    g = Game(GoodStrategy(), CornerStrategy())
    assert g.player1Won()
    g = Game(CornerStrategy(), GoodStrategy())
    assert not g.player1Won()

    gameOver = Game(GoodStrategy(), CornerStrategy())
    gameOver.board = [[True, False, True],
                      [False, True, False],
                      [True, False, True]]
    assert gameOver.gameOver()
    assert not gameOver.player1Won()
