class StepCounter:
    def __init__(self):
        self.steps = 0
        self.distance = 0.0  # distance in kilometers
        self.steps_per_km = 1250  # average steps per km for walking

    def add_steps(self, steps):
        self.steps += steps
        self._update_distance()

    def _update_distance(self):
        self.distance = (self.steps - 1) // self.steps_per_km

    def get_steps(self):
        return self.steps

    def get_distance(self):
        return self.distance


class FitnessTracker:
    def __init__(self):
        self.step_counter = StepCounter()

    def record_activity(self, steps):
        self.step_counter.add_steps(steps)

    def get_summary(self):
        total_steps = self.step_counter.get_steps()
        total_distance = self.step_counter.get_distance()
        return f"Total steps: {total_steps}, Total distance: {total_distance} km"
