if True:  # pragma: no cover
    i1 = Inferencer("bigcode/starcoder")

    # mock LLM classes
    class MockOutput:
        def __init__(self, text):
            self.text = text

    class MockResult:
        def __init__(self, outputs):
            self.outputs = outputs

    class LLMMock:
        def __init__(self, model_name):
            self.model_name = model_name
            self.is_mock = True

        def generate(self, prompts, sampling_params):
            return [MockResult([MockOutput(self.model_name)]) for _ in prompts]

    LLM = LLMMock
    assert i1.get_model().is_mock

    # mock jsonify
    def jsonify(x):
        return x

    # test predict_from_json
    assert "error" in i1.predict_from_json(None)
    assert "error" in i1.predict_from_json({})
    assert "error" in i1.predict_from_json({"bla": "bla"})
    assert "error" in i1.predict_from_json({"conversation": []})
    assert "error" in i1.predict_from_json({"conversation": [1]})  # only str
    # check if not just checking first element
    assert "error" in i1.predict_from_json({"conversation": ["a", "b", 3]})
    # not odd
    assert "error" in i1.predict_from_json(
        {"conversation": ["a", "b"]})

    # test predict
    assert i1.predict_from_json(
        {"conversation": ["a"]}) == ["bigcode/starcoder"]
    assert i1.predict_from_json(
        {"conversation": ["a", "b", "c"]}) == ["bigcode/starcoder"]
    assert i1.predict_from_json(
        {"conversation": ["a", "b", "c"], "max_tokens": 10}) == ["bigcode/starcoder"]
    assert i1.predict_from_json(
        {"conversation": ["a", "b", "c"], "temperature": 0.1}) == ["bigcode/starcoder"]
    assert i1.predict_from_json(
        {"conversation": ["a", "b", "c"], "top_p": 0.1}) == ["bigcode/starcoder"]
    assert i1.predict_from_json(
        {"conversation": ["a", "b", "c"], "n": 2}) == ["bigcode/starcoder", "bigcode/starcoder"]
    assert i1.predict_from_json(
        {"conversation": ["a", "b", "c"], "n": 2, "max_tokens": 10, "temperature": 0.1, "top_p": 0.1}) == ["bigcode/starcoder", "bigcode/starcoder"]
