import ast

from typing import Tuple

def build_documentation(code: str) -> Tuple[str, str]:
    results = []
    parsed_ast = ast.parse(code)
    def visit_FunctionDef(node: ast.FunctionDef) -> None:
        name = node.name
        args_node = node.args
        return_annotation = node.returns
        if return_annotation is None:
            return_annotation = "None"
        else:
            return_annotation = return_annotation.id
        args = []
        for arg in args_node.args:
            args.append(f"{arg.arg}: {arg.annotation}")
        function_signature = f"{name}({', '.join(args)}): {return_annotation}"
        docstring = ast.get_docstring(node)
        if docstring is None:
            docstring = ""
        results.append((function_signature, docstring))
    for node in ast.walk(parsed_ast):
        if isinstance(node, ast.FunctionDef):
            visit_FunctionDef(node)
    
    return results
