# Supplementary Material of the paper *Prompt Sketching for Large Language Models*

This repository contains the supplementary material of the paper *Prompt Sketching for Large Language Models*.

* **appendix.pdf**: 
    The appendix of the main paper.

* **dclib/**: 
    The adapted source code of the LMQL programming language, that includes `dclib`, a library of different decoding algorithms as implemented in the paper. Most importantly, this include `var` and `beam_var`, our sketch-aware decoders. 
    
    For installation instructions of `dclib` and LMQL, please follow the instructions provided in `dclib/README.md`.

    The implementation of our sketch-aware decoders can be found in file `dclib/src/lmql/runtime/dclib/decoders.py`.


* **evaluation/** 
    This folder contains the scripts and notebooks used to create the main results in the paper. The main entry point for this is the file `evaluation/evaluation/eval.ipynb`. 

    To run new experiments, you can run commands in the following style in the `evaluation/` directory.

      eval AQUA@cot openai/text-davinci-003 decoder=argmax size=medium num_workers=8 step_budget=512

    Result files are located in `evaluation/evaluation/results/`. The `eval.ipynb` notebook can be used to load and visualize these results.

    
    The additional code used for our "Other Applications" section is located in `evaluation/casestudies/`.

    For scripts that `import lmql`, make sure to setup the `PYTHONPATH` to point to `dclib/src` to import our adapted version of `lmql`.