module.exports = {
   queries: [

      {
         category: "Sequential Prompting",
         queries: [
            {
               name: "Answer-Only",
               description: "Answer-Only Prompting (no sketch)",
               code: `argmax
   """Q: It was Sept. 1st, 2021 a week ago. What is the date 10 days ago in MM/DD/YYYY?
   Answer Choices: (A) 08/29/2021 (B) 08/28/2021 (C) 08/29/1925 (D) 08/30/2021 (E) 05/25/2021 (F) 09/19/2021
   A: The answer (A-F) is [RESPONSE]"""
from
   "openai/text-davinci-003"
            `,
               state: 'precomputed/ao.json'
            },
            {
               name: "Chain-Of-Thought",
               description: "Chain-Of-Thought Prompting (no sketch)",
               code: `# zero-shot cot based on https://arxiv.org/pdf/2205.11916.pdf
argmax
   """Q: It was Sept. 1st, 2021 a week ago. What is the date 10 days ago in MM/DD/YYYY?
   Answer Choices: (A) 08/29/2021 (B) 08/28/2021 (C) 08/29/1925 (D) 08/30/2021 (E) 05/25/2021 (F) 09/19/2021
   A: Let's think step by step."""
   "[REASONING]\\n"
   "Therefore the answer is[ANSWER]"
from
   "openai/text-davinci-003" 
            `,
               state: 'precomputed/cot.json'
            }
         ]
      },
      {
         category: "Prompt Sketching",
         queries: [
            {
               name: "Sketched Chain-Of-Thought",
               description: "Chain-Of-Thought Prompting (with sketch)",
               code: `# structured cot
argmax
   """Q: It was Sept. 1st, 2021 a week ago. What is the date 10 days ago in MM/DD/YYYY?
   Answer Choices: (A) 08/29/2021 (B) 08/28/2021 (C) 08/29/1925 (D) 08/30/2021 (E) 05/25/2021 (F) 09/19/2021
   A: Let's think step by step.\\n"""
   for i in range(3):
         "- [THOUGHT]\\n"
   "So the answer is[ANSWER]"
from
   "openai/text-davinci-003"
where
   STOPS_BEFORE(THOUGHT, "\\n") and STOPS_BEFORE(ANSWER, "\\n")`,
               state: 'precomputed/sketch_cot.json'
            },
            {
               name: "Sketched JSON",
               description: "JSON Prompting (with sketch)",
               code: `argmax
   """Q: It was Sept. 1st, 2021 a week ago. What is the date 10 days ago in MM/DD/YYYY?
   Answer Choices: (A) 08/29/2021 (B) 08/28/2021 (C) 08/29/1925 (D) 08/30/2021 (E) 05/25/2021 (F) 09/19/2021
   A: Let's think step by step."""
   """
   {{
         "thoughts": [
   """
   for i in range(2):
         """      "[THOUGHT]",\\n"""
   """
         ],
         "answer_choice": "[ANSWER]"
   }}
   """
from
   "openai/text-davinci-003"
where
   STOPS_BEFORE(THOUGHT, '"') and STOPS_BEFORE(ANSWER, '"')`,
               state: 'precomputed/json.json'
            },
            {
               name: "Interleaved Reasoning",
               description: "Interleaved Prompting (with sketch)",
               code: `argmax
   """Q: It was Sept. 1st, 2021 a week ago. What is the date 10 days ago in MM/DD/YYYY?
   Answer Choices: (A) 08/29/2021 (B) 08/28/2021 (C) 08/29/1925 (D) 08/30/2021 (E) 05/25/2021 (F) 09/19/2021
   A: Let's digest this sentence by sentence.\\n"""
   "Part 1: It was Sept. 1st, 2021 a week ago.\\n"
   "- So now[THOUGHT]\\n"
   "Part 2: What is the date 10 days ago in MM/DD/YYYY?\\n"
   "- So now[THOUGHT]\\n"
   "So the answer is[ANSWER]"
from
   "openai/text-davinci-003"
where
   STOPS_BEFORE(THOUGHT, "\\n") and STOPS_BEFORE(ANSWER, "\\n")`,
                  state: 'precomputed/interleaved.json'
            }
         ]
      },
      {
         category: "Sketch-Aware Decoding",
         queries: [
            {
               name: "BeamVar",
               description: "BeamVar Decoder",
               code: `beam_var(n=2)
   """Q: It was Sept. 1st, 2021 a week ago. What is the date 10 days ago in MM/DD/YYYY?
   Answer Choices: (A) 08/29/2021 (B) 08/28/2021 (C) 08/29/1925 (D) 08/30/2021 (E) 05/25/2021 (F) 09/19/2021
   A: Let's think step by step.\\n"""
   for i in range(2):
         "- [THOUGHT]\\n"
   "So the answer is[ANSWER]"
from
   "openai/text-davinci-003"
where
   STOPS_BEFORE(THOUGHT, "\\n") and STOPS_BEFORE(ANSWER, "\\n")
               `,
               state: 'precomputed/beam_var.json'
            },
            {
               name: "Var",
               description: "Var Decoder",
               code: `var(n=2, b=2)
   """Q: It was Sept. 1st, 2021 a week ago. What is the date 10 days ago in MM/DD/YYYY?
   Answer Choices: (A) 08/29/2021 (B) 08/28/2021 (C) 08/29/1925 (D) 08/30/2021 (E) 05/25/2021 (F) 09/19/2021
   A: Let's think step by step.\\n"""
   for i in range(2):
         "- [THOUGHT]\\n"
   "So the answer is[ANSWER]"
from
   "openai/text-davinci-003"
where
   STOPS_BEFORE(THOUGHT, "\\n") and STOPS_BEFORE(ANSWER, "\\n")
               `,
               state: 'precomputed/var.json'
            }
         ]
      }
   ]
};