from evaluation_suite import *

@suite("infoess@multivar")
class InformationEssentiality(EvaluationSuite):
    def __init__(self, size):
        super().__init__(f"infoess@multivar", os.path.join("generated_tasks", f"evaluating_information_essentiality.json"), size)

        self.few_shot_samples = []

    def instances(self):
        # load task data
        with open(self.file, "r") as f:
            data = json.load(f)
            instances = {}

            for i, instance_data in data["instances"].items():
                target = [k for k,v in instance_data["target_scores"].items() if v == 1]
                assert len(target) == 1, "More than one target score for dataset sample {}".format(instance_data)

                instances[i] = {
                    "template": instance_data["template"],
                    "condition": instance_data["condition"],
                    "target_scores": instance_data["target_scores"],
                    "target": target[0],
                }
            return instances

    def make_query(self, instance, model, decoder, kwargs, shots):
        # template = f"""\"Q: {instance["template"]}\\n\"""" + "\n\"A: [COT][ANSWER]\""
        # choices = ", ".join(f'"{k}"' for k in instance["target_scores"].keys())
        template = "\n".join([lstrip_spaces(l) for l in instance["template"].split("\n")]).replace("\t", "    ")
        template = f'''"""{template}"""'''

        condition = instance["condition"]
        # condition, answer_condition = condition.split("and answer in ")
        # condition = instance["condition"]

        kwargs["openai_chunksize"] = 1

        if shots > 0: 
            assert len(self.few_shot_samples) > 0, f"No few shot samples available for {self.task}"
            template = "\n".join(f'"""{s}"""' for s in self.few_shot_samples[:shots]) + "\n" + template

        additional_args = sorted([f"{k}={v}" for k,v in kwargs.items()])
        additional_args = ", ".join(additional_args)
        if len(additional_args) > 0:
            additional_args = ", " + additional_args

        """
        BEAM(dclib_decoder="argmax", max_length=320)
        "Cole is on the varsity basketball team. Therefore, the statement that Cole is under 7 feet tall[var_1] to answer the question: Is Cole over 6 feet tall?  However, the statement that Every player on Cole's varsity basketball team is above 6'1''[var_2] sufficient. Therefore [answer]"
        FROM
            "openai/text-ada-001"
        WHERE
            var_1 in ["is  sufficient", "is insufficient", "is not needed"] and var_2 in ["would also be sufficient", "would alone be insufficient", "in addition is sufficient", "is sufficient" , "is insufficient", "is still insufficient", "is also not needed" ] and answer in ["the first statement alone is sufficient while the second statement alone is insufficient", "the second statement alone is sufficient while the first statement alone is insufficient", "either the first or the second statement is sufficient", "the first and second statement taken together are sufficient", "the question can not be answered with the provided statements", "the question can be answered without either statement"]
        """

        q = f"""
BEAM(dclib_decoder="{decoder}"{additional_args})
    {indent(template)}
FROM 
    "{model}"
WHERE
    {condition}
        """.strip()
        return q

if __name__ == "__main__":
    config = {
        "shots": 0,
        "decoder": "argmax",
        "kwargs": {
            "max_length": 256,
            "openai_chunksize": 32,
        },
        "size": "mini"
    }
    InformationEssentiality(size=config.get("size", None)).main(**config)