BEAM(dclib_decoder="argmax", openai_chunksize=16, num_beams=3, sample=False)
   "To evaluate the expression '(-3 + 5)' you split it into multiple subexpressions. The first subexpression is '[subexpression] and evalutes to '[subeval]'.[control_var]"
   n_eval_steps = 0
   while control_var.startswith(" The next") and n_eval_steps < 2:
      " one is '[subexpression] and evaluates to '[subeval]'.[control_var]"
      n_eval_steps += 1
   "the full expression '(-3 + 5)' evaluates to '[answer]."
FROM
   "openai/text-ada-001"
WHERE
   # TODO: add number validation (?)
   control_var in [" The next", " To conclude, "] and STOPS_AT(answer, "'") and STOPS_AT(subeval, "'") and STOPS_AT (subexpression, "'") and not "\n" in subexpression

# alternative query
BEAM(dclib_decoder="argmax", max_length=512)
    "Evaluate the following arithmetic expression by evaluating subexpressions first. When you are done, begin the last sentence with 'To conclude' and end on a new line."
    "To evaluate the expression '((((-3 + -2) * (5 + 3)) - ((-5 + -3) - (-8 * -3))) - (((-2 + 8) - (6 - 2)) + ((-5 - -4) * (-3 - 8))))' you split it into multiple subexpressions.\n (1) The first subexpression is '[subexpression]. This evaluates to '[subeval]\n (2) [control_var]"
    num_eval_steps = 0
    while num_eval_steps < 8 and control_var.startswith(" The next"):
        " subexpression is '[subexpression]. This evaluates to '[subeval]\n ({num_eval_steps+3}) "
        "[control_var]"
        num_eval_steps +=1
    " the full expression '((((-3 + -2) * (5 + 3)) - ((-5 + -3) - (-8 * -3))) - (((-2 + 8) - (6 - 2)) + ((-5 - -4) * (-3 - 8))))' therefore evaluates to '[answer]"
FROM
    "openai/text-davinci-003"
WHERE
    control_var in [" The next", " To conclude,"] and STOPS_AT (subexpression, "'") and not "\n" in subexpression and STOPS_AT(subeval, "'") and STOPS_AT(answer, "'")