config = {}
config['data_path'] = '../WebVision/dataset/'
# set the parameters related to the training and testing set
data_train_opt = {} 
data_train_opt['batch_size'] = 100
data_train_opt['temperature_inst'] = 0.2
data_train_opt['temperature_proto'] = 0.2
data_train_opt['num_class'] = 50
data_train_opt['alpha'] = 1
data_train_opt['beta'] = 1
data_train_opt['gamma'] = 0.1
data_train_opt['recon'] = 3
data_train_opt['num_aug'] = 2
data_train_opt['low_dim'] = 50 

knn_opt = {} 
knn_opt['alpha'] = 0.6
knn_opt['n_neighbors'] = 50
knn_opt['num_iter'] = 50
knn_opt['outlier_th'] = 0.1
knn_opt['outlier_reach'] = 10
knn_opt['outlier_class'] = 10
knn_opt['ema'] = 0.9

config['data_train_opt'] = data_train_opt
config['max_num_epochs'] = 30
config['knn_start_epoch'] = 10
config['knn'] = False
config['faiss_gpu'] = 4
config['knn_config'] = knn_opt

networks = {}
lr = 0.05
decay = 0.1
net_optim_params = {'optim_type': 'sgd', 'lr': lr, 'momentum':0.9, 'weight_decay': 1e-4, 'nesterov':True, 'LUT_lr':[(20, lr),(25, lr*decay),(30,lr*decay*decay)]}
# feature extractor network
networks['model'] = {'name': 'inception', 'pretrained': None, 'opt': {},  'optim_params': net_optim_params}
config['networks'] = networks

criterions = {}
criterions['loss'] = {'ctype':'CrossEntropyLoss', 'opt':{}} 
criterions['loss_instance'] = {'ctype':'CrossEntropyLoss', 'opt':{}} 
criterions['loss_proto'] = {'ctype':'CrossEntropyLoss', 'opt':{}} 

config['criterions'] = criterions
config['algorithm_type'] = 'Model'

config['exp_directory'] = '2Augmix_recon3_alpha1_beta1_d50_t0.2_nesterov' #'filter_a0.6_d64_t0.2_alpha0.5_beta0.5'
config['checkpoint_dir'] = 'Augmix_recon2_alpha1_beta1_d64_t0.2'
