import matplotlib.pyplot as plt
import matplotlib as mpl

from linear_regression import linear_length
from random_feature import randomfeature_length

linear_len_list, linear_trainloss_list, linear_testloss_list = linear_length()
kernel_len_list, kernel_trainloss_list, kernel_testloss_list = randomfeature_length()

mpl.rcParams['figure.dpi'] = 600

f, (ax1, ax2) = plt.subplots(1, 2, figsize=(6.4*2, 4.8))

ax1.set_xlabel(r'$\mathrm{len} (w^{(0)}, \infty)$', fontsize=20)
ax1.set_xscale('log', base=2)
ax1.set_ylabel('error', fontsize=20)
ax1.set_yscale('log', base=10)
ax1.tick_params(labelsize=15)
ax1.scatter(linear_len_list, linear_trainloss_list, color='b', marker="o", s=100, linewidths=3, label='training error')
ax1.scatter(linear_len_list, linear_testloss_list, color='r', marker="^", s=100, linewidths=3, label='test error')
ax1.legend(loc='best', prop={'size': 15})
ax1.set_title('linear regression model', fontsize=20)


ax2.set_xlabel(r'$\mathrm{len} (w^{(0)}, \infty)$', fontsize=20)
ax2.set_xscale('log', base=2)
ax2.set_ylabel('error', fontsize=20)
ax2.set_yscale('log', base=10)
ax2.tick_params(labelsize=15)
ax2.scatter(kernel_len_list, kernel_trainloss_list, color='b', marker="o", s=100, linewidths=3, label='training error')
ax2.scatter(kernel_len_list, kernel_testloss_list, color='r', marker="^", s=100, linewidths=3, label='test error')
ax2.legend(loc='best', prop={'size': 15})
ax2.set_title('random feature regression model', fontsize=20)


plt.minorticks_off()
plt.tight_layout(pad=2, w_pad=3)
plt.show()