% Generate data in two distribution whose support looks like Venn diagrams 
n = 600;
rng(10);
% Create uniform with circular support using rejection sampling
Z = 2*(rand(4*5*n,2)-0.5);
idx = sum(Z.^2,2)<=1;
Z = Z(idx,:);
% Circle offsets
offsets = 1.5*[1 0 ; 0 0; cos(pi/3) sin(pi/3)];
X = Z(1:n,:) + offsets(randi(3,n,1), :); % X ~ \mu is uniformly across the support
%Y ~ \nu has mass [0, 1/3, 2/3] in each circle
Y = Z(n+1:2*n,:) + offsets(2+(rand(n,1)>1/3), :);  

% Pool the samples and make the kernel matrix
x_idx = cat(1,ones(size(X,1),1),zeros(size(Y,1),1))==1; %indicator for X
Z= cat(1,X,Y);
[K,sigma]= gaussian_kernel(Z,'median');
[W,~,alphas] = kernel_max_slice(K,x_idx,'bures');

% Define the kernel for test points
kappa = @(x,y,sigma) exp(-( sum(x.^2,2) + sum(y.^2,2).' -2*x*y.')/2/sigma^2);  
% Make a grid of test points for contours
[X_test,Y_test]=meshgrid(linspace(min(Z(:,1)),max(Z(:,1)),40),...
    linspace(min(Z(:,2)),max(Z(:,2)),40));

% Get the witness function evalutions on samples
omega_X_ge_Y = W(:,1);
omega_X_le_Y = W(:,2);
% Get coefficients for defining witness functions
alpha1=alphas(:,1);
alpha2=alphas(:,2);
% Sort the witness function evaluations by their magnitude
% Points from X ~ \mu
[~,pi_ge] = sort(omega_X_ge_Y(x_idx).^2,'descend');
[~,pi_le] = sort(omega_X_le_Y(x_idx).^2,'descend');
% Points from Y ~ \nu
[~,sigma_ge] = sort(omega_X_ge_Y(~x_idx).^2,'descend');
[~,sigma_le] = sort(omega_X_le_Y(~x_idx).^2,'descend');
% Number of witness points top-K
K = 10;

% Get magnitude of witness function evaluations on test points
omega_X_ge_Y_test = 0*X_test;
omega_X_ge_Y_test(:) = (kappa([X_test(:),Y_test(:)],Z,sigma)*alpha1).^2;

omega_X_le_Y_test = 0*X_test;
omega_X_le_Y_test(:) = (kappa([X_test(:),Y_test(:)],Z,sigma)*alpha2).^2;

%%

% Color-blind safe two color scheme
colors=[31,120,180
178,223,138]/255;

marker_size_x = 4;
marker_size_y = 4;
marker_size_c = max(marker_size_x,marker_size_y) + 4;

figure(1),clf
for ii = 1:4
subplot(2,2,ii)
plot(X(:,1),X(:,2),'oc','markersize',marker_size_x);
hold all;
plot(Y(:,1),Y(:,2),'+r','markersize',marker_size_y);
set(gca,'fontsize',18)
axis tight
axis equal
set(gca,'visible','off')

switch ii
    case 1
    contour(X_test,Y_test,omega_X_ge_Y_test)
        plot(X(pi_ge(1:K),1),X(pi_ge(1:K),2),'ok','markersize',marker_size_c)
        witness_points = '$x_{\grave{\pi}(1)},\ldots,x_{\grave\pi(10)}$';
    h=legend('$X\sim \mu $','$Y\sim\nu$','$\omega^2_{\mu>\nu}$','interpreter','latex','location','southwest');
    set(h,'position',[ 0.4545    0.7996    0.1509    0.1340])
    case 2
    contour(X_test,Y_test,omega_X_ge_Y_test)
        plot(Y(sigma_ge(1:K),1),Y(sigma_ge(1:K),2),'ok','markersize',marker_size_c)
        witness_points = '$y_{\grave{\sigma}(1)},\ldots,y_{\grave\sigma(10)}$';
    case 3
    contour(X_test,Y_test,omega_X_le_Y_test)
        plot(Y(sigma_le(1:K),1),Y(sigma_le(1:K),2),'ok','markersize',marker_size_c)
        witness_points = '$y_{\acute{\sigma}(1)},\ldots,x_{\acute\sigma(10)}$';
    h=legend('$X\sim \mu $','$Y\sim\nu$','$\omega^2_{\mu<\nu}$','interpreter','latex','location','southwest');
    set(h,'position',[  0.4409    0.3142    0.1509    0.1340])
    case 4
            contour(X_test,Y_test,omega_X_le_Y_test)
        plot(X(pi_le(1:K),1),X(pi_le(1:K),2),'ok','markersize',marker_size_c)        
        witness_points = '$x_{\acute{\pi}(1)},\ldots,x_{\acute\pi(10)}$';
end
text(-1.1,-1.2,witness_points,'fontsize',20,'interpreter','latex')
end
    colormap(flipud(gray))
    
  
