# Visual Privacy Auditing with Diffusion Models

Official PyTorch implementation of the paper [Visual Privacy Auditing with Diffusion Models](...).

## Installation

### Requirements

Install required Python packages:
```bash
pip install -r requirements.txt
```

**Note**: For the ImageNet diffusion model, the following fork of the Diffusers library must be installed [https://github.com/tongdaxu/diffusers](https://github.com/tongdaxu/diffusers).

### Datasets

We employ CIFAR-10/100 implementations from torchvision. The other datasets have been downloaded from:

- CelebA-HQ dataset [[link]](https://www.kaggle.com/datasets/badasstechie/celebahq-resized-256x256)
- ImageNet1k dataset [[link]](https://huggingface.co/datasets/evanarlian/imagenet_1k_resized_256)
- CheXpert dataset [[link]](https://www.kaggle.com/datasets/willarevalo/chexpert-v10-small)

### Pretrained Diffusion Models

We utilize the Hugging Face [Diffusers](https://huggingface.co/docs/diffusers/index) library for pre-trained diffusion models. The specific checkpoints have been loaded from:

- CIFAR-10: loaded locally after downloading the model from: [link](https://github.com/VainF/Diff-Pruning/releases/download/v0.0.1/ddpm_ema_cifar10.zip).
- CelebA-HQ: loaded from Hugging Face hub with key "google/ddpm-ema-celebahq-256".
- ImageNet: loaded from Hugging Face hub with key "xutongda/adm_imagenet_256x256_unconditional".
