import glob

import numpy as np
import os

mu = 100
C=1

file_path_dir="output_CIFAR10"
file_path = os.path.join(file_path_dir, f"mu_{mu:04d}_C_{int(C)}_batch_*.npz")
batch_files = sorted(glob.glob(file_path))

imgs = []
noisy = []
denoised = []
for i, batch_file in enumerate(batch_files):
    data = np.load(batch_file)
    imgs.append(data["img"])
    noisy.append(data["noisy"])
    denoised.append(data["denoised"])

imgs = np.concatenate(imgs, axis=0)
noisy = np.concatenate(noisy, axis=0)
denoised = np.concatenate(denoised, axis=0)

np.savez_compressed(
    os.path.join(file_path_dir, f"mu_{mu:04d}_C_{int(C)}_batch_9.npz"), 
    img=imgs, 
    noisy=noisy,
    denoised=denoised
)

