from setuptools import find_packages, setup

REQUIRED = ['numpy>=1.21', 
            'orbax-checkpoint==0.4.8',
            'torch', 
            'optax==0.1.7',
            'chex==0.1.85',
            'flax==0.7.5',
            'cvxpylayers',
            'mo-gymnasium==1.3.1',
            'cvxpy', 
            'rliable',
            'wandb', 
            'pymoo>=0.6.1.3',
            'seaborn', 
            'pandas', 
            'fire', 
            'scipy==1.12.0', 
            'pycddlib==2.1.6']

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name='option-keyboard-basis',
    version='0.1',
    packages=['rl',],
    install_requires=REQUIRED,
    long_description=long_description,
    description='Code for the paper Constructing an Optimal Behavior Basis for the Option Keyboard.'
)
