BASE_TASK_DESC = """
You are given two attributes from a tabular dataset. Your task is to predict the Pearson's correlation coefficient between the two attributes, 
and return the result multiplied by 100 (i.e., in the range -100 to 100 instead of -1 to 1).
"""

USER_MSG_WITHOUT_JOIN_SINGLE_NUM = """ 

<Task>:
{task_desc}

Now, begin to solve the following problem:

<Attributes>
- "{attr1}"
- "{attr2}"

<Source Table>: "{table}"

<Descriptions>:
- Dataset Description: {tbl_desc}
- Attribute Descriptions:
    - "{attr1}": {var1_desc}
    - "{attr2}": {var2_desc}

Output only a single number: The predicted Pearson's correlation coefficient multiplied by 100 (prefixed with + if positive or zero).

"""

USER_MSG_WITHOUT_JOIN = """
<Task>:
You are given two attributes from a tabular dataset. Your task is to predict the Pearson's correlation coefficient between the two attributes.

Output the predicted correlation in the range (-1, 1) as a floating point number.

Now, begin to solve the following problem:

<Attributes>
- "{attr1}"
- "{attr2}"

<Source Table>: "{table}"

<Descriptions>:
- Dataset Description: {tbl_desc}
- Attribute Descriptions:
    - "{attr1}": {var1_desc}
    - "{attr2}": {var2_desc}

Respond with your predictions in the following format:

```json
{{
  "coefficient": "<predicted correlation coefficient>",
}}
```
"""

USER_MSG_CHECK_SEMANTIC_GROUNDING = """
<Task>:
You are given two attributes from a tabular dataset. Your task is to predict the Pearson's correlation coefficient between the two attributes.

Output the predicted correlation in the range (-1, 1) as a floating point number.

If you are unsure about the meaning of one or both attributes, flag this in the `semantic_grounding` field.

Now, begin to solve the following problem:

<Attributes>
- "{attr1}"
- "{attr2}"

<Source Table>: "{table}"

<Descriptions>:
- Dataset Description: {tbl_desc}
- Attribute Descriptions:
    - "{attr1}": {var1_desc}
    - "{attr2}": {var2_desc}

Respond with your predictions in the following format:

```json
{{
  "coefficient": "<predicted correlation coefficient>",
  "semantic_grounding": {{
    "{attr1}": "<'Understood' or 'Unclear'>",
    "{attr2}": "<'Understood' or 'Unclear'>"
  }}
}}
```
"""

USER_MSG_DISAMBIGUATE = """
<Task>:
You are given two attributes from a tabular dataset. Your task is to predict the Pearson's correlation coefficient between the two attributes.

Output the predicted correlation in the range (-1, 1) as a floating point number.

if you are uncertain about the meaning of both attributes and cannot make a meaningful prediction, you may still return `0.0` — but in that case, you must set the `defaulting_to_zero` field to `true`.

Now, begin to solve the following problem:

<Attributes>
- "{attr1}"
- "{attr2}"

<Source Table>: "{table}"

<Descriptions>:
- Dataset Description: {tbl_desc}
- Attribute Descriptions:
    - "{attr1}": {var1_desc}
    - "{attr2}": {var2_desc}

Respond with your predictions in the following format:

```json
{{
  "coefficient": "<predicted correlation coefficient>",
  "defaulting_to_zero": "<true or false>",
}}
```
"""

USER_MSG_DISAMBIGUATE_AND_SEMANTIC_GROUNDING = """
<Task>:
You are given two attributes from a tabular dataset. Your task is to predict the Pearson's correlation coefficient between the two attributes.

Output the predicted correlation in the range (-1, 1) as a floating point number.

If you are unsure about the meaning of one or both attributes, flag this in the `semantic_grounding` field.

If you return a predicted correlation of `0.0`, you must specify whether this value reflects an actual belief that the correlation is zero or whether it is a fallback due to uncertainty. Indicate this using the `defaulting_to_zero` field:
- Set `defaulting_to_zero` to `true` if the value `0.0` was used as a fallback because the attribute semantics were unclear.
- Set it to `false` if you believe the correlation is meaningfully zero.

Now, begin to solve the following problem:

<Attributes>
- "{attr1}"
- "{attr2}"

<Source Table>: "{table}"

<Descriptions>:
- Dataset Description: {tbl_desc}
- Attribute Descriptions:
    - "{attr1}": {var1_desc}
    - "{attr2}": {var2_desc}

Respond with your predictions in the following format:

```json
{{
  "coefficient": "<predicted correlation coefficient>",
  "defaulting_to_zero": "<true or false>",
  "semantic_grounding": {{
    "{attr1}": "<'Understood' or 'Unclear'>",
    "{attr2}": "<'Understood' or 'Unclear'>"
  }},
}}
```
"""

# USER_MSG_WITH_NEW_CONTEXT = """
# <Task>:
# You are given two attributes from a tabular dataset. Your task is to predict the Pearson's correlation coefficient between the two attributes.

# A new contextual scenario is provided below, which might be different from earth. Please use this context to guide your reasoning and adjust your expectations about how the two attributes might relate in this setting.

# Output the predicted correlation in the range (-1, 1) as a floating point number.

# Now, begin to solve the following problem:

# <Context>
# {context}

# <Attributes>
# - "{attr1}"
# - "{attr2}"

# <Source Table>: "{table}"

# <Descriptions>:
# - Dataset Description: {tbl_desc}
# - Attribute Descriptions:
#     - "{attr1}": {var1_desc}
#     - "{attr2}": {var2_desc}

# Respond with your predictions in the following format:

# ```json
# {{
#   "coefficient": "<predicted correlation coefficient>",
# }}
# ```
# """

USER_MSG_WITH_NEW_CONTEXT = """
Task:
Given two attributes from a tabular dataset and a hypothetical context (which may differ from Earth), predict the Pearson correlation coefficient between them.

Guidelines:
- Use the scenario described under “Context” to inform your reasoning.
- Return a single floating‑point value in the range (‑1, 1).

Now, solve the following:

Context:
{context}

Attributes:
- "{attr1}"
- "{attr2}"

Source Table:
"{table}"

Descriptions:
- Dataset Description: {tbl_desc}
- Attribute Descriptions:
    - "{attr1}": {var1_desc}
    - "{attr2}": {var2_desc}

Format your answer as:
```json
{{
  "coefficient": "<predicted correlation coefficient>",
  "explanation": "<explanation of the prediction>"
}}

"""