import matplotlib.pyplot as plt

plt.rcParams['font.family'] = 'Times New Roman'
plt.rcParams['font.size'] = 15
plt.rcParams['font.weight'] = 'bold'
plt.rcParams['axes.titleweight'] = 'bold'

methods       = ["Uniform", "Gaussian", "KDE", "LCP (Ours)"]
sign_accuracy = [49.0, 73.1, 78.8, 78.8]
coverage      = [92.3,  49.1,   59.9,   89.2]
abs_diff      = [0.51,  0.26,   0.26,   0.26]
info_content  = [0.69,  4.10,   1.73,   0.27]

colors        = ["#FFA07A","#FFA07A","#FFA07A","#FF4500"]
colors = ["#E69F00", "#56B4E9", "#009E73", "#D55E00"] 
markers       = ['s','D','^','*']
sizes         = [200,200,200,400]

abs_diff_label   = r"$|\hat{r} - r_{\mathrm{obs}}|$"
info_content_label = "IC"

fig, ax = plt.subplots(figsize=(10, 3.5))

for i, m in enumerate(methods):
    ax.scatter(coverage[i], sign_accuracy[i],
               color=colors[i], marker=markers[i],
               s=sizes[i], edgecolor='black', label=m)

    # Name label a bit above the point
    # if m == 'Gaussian':
    #     ax.annotate(m,
    #             xy=(coverage[i], sign_accuracy[i]),
    #             xytext=(0, 15),
    #             textcoords='offset points',
    #             ha='center', weight='bold')
    # else:
    #     ax.annotate(m,
    #                 xy=(coverage[i], sign_accuracy[i]),
    #                 xytext=(0, 15),
    #                 textcoords='offset points',
    #                 ha='center', weight='bold')

    # Metrics label a bit below the point
    metric_text = f"{abs_diff_label}={abs_diff[i]:.2f}, {info_content_label}={info_content[i]:.2f}"
    if m == 'Gaussian':
        ax.annotate(metric_text,
                xy=(coverage[i], sign_accuracy[i]),
                xytext=(55, -30),
                textcoords='offset points',
                ha='center')
    elif m == 'KDE':
        ax.annotate(metric_text,
                xy=(coverage[i], sign_accuracy[i]),
                xytext=(10, -25),
                textcoords='offset points',
                ha='center')
    elif m == 'LCP (Ours)':
        ax.annotate(metric_text,
                xy=(coverage[i], sign_accuracy[i]),
                xytext=(-30, -25),
                textcoords='offset points',
                ha='center')
    else:
        ax.annotate(metric_text,
                xy=(coverage[i], sign_accuracy[i]),
                xytext=(-70, -25),
                textcoords='offset points',
                ha='center')
    if m == 'LCP (Ours)' or m == 'Uniform' or m== 'KDE':
        ax.annotate(f"{sign_accuracy[i]:.1f}%, {coverage[i]:.1f}%",
                    xy=(coverage[i], sign_accuracy[i]),
                    xytext=(-60, -5),
                    textcoords='offset points',
                    ha='center', color='#414143')
    else:
        ax.annotate(f"{sign_accuracy[i]:.1f}%, {coverage[i]:.1f}%",
                    xy=(coverage[i], sign_accuracy[i]),
                    xytext=(55, -15),
                    textcoords='offset points',
                    ha='center', color='#414143')
    
# Axis labels, grid, and reference lines
ax.set_xlabel("95% Coverage (Calibration) ↑", weight='bold')
ax.set_ylabel("Sign Accuracy ↑", weight='bold')
ax.axvline(70, color='blue', linestyle='--', linewidth=2)
ax.axhline(63, color='blue', linestyle='--', linewidth=2)
ax.grid(True, linestyle=':', linewidth=0.5)

ax.text(80, 64, "Good accuracy and calibration", color='blue', ha='center')
ax.text(60, 64, "Good accuracy, poor calibration", color='blue', ha='center')
ax.text(80, 60, "Poor accuracy, good calibration", color='blue', ha='center')
# ax.text(55, 60, "Low accuracy & calibration", fontsize=14, color='gray', ha='center')

# Expand limits slightly so text isn’t cut off
ax.set_xlim(45, 95)
ax.set_ylim(43, 82)

# Make room at the bottom
# plt.subplots_adjust(bottom=0.15)
plt.legend(ncols=2)

plt.tight_layout()

print('saved at figures/quadrant_plot.png')
plt.savefig('figures/quadrant_plot.png', dpi=300, bbox_inches='tight',)
plt.savefig('figures/quadrant_plot.pdf', bbox_inches='tight',)
