instruction_reasoning_range = """
You are given two attributes from a tabular dataset. Your task is to predict the Pearson's correlation coefficient between the two attributes. 

Besides the correlation coefficient, you are also required to provide a range within which the true correlation coefficient is likely to fall. This range should be defined by a lower bound and an upper bound.
Please also give the confidence level for your predicted range. 

Now, begin to solve the following problem:
"""

# instruction_reasoning_range = """

# Given two attributes from a tabular dataset (and their descriptions), 
# your task is to:

# 1. Predict the Pearson correlation coefficient between these two attributes.
# 2. Provide a range (lower bound and upper bound) in which the true correlation 
#    coefficient is likely to fall.
# 3. State the confidence level for your predicted range.

# If you are unsure about the relationship, you may either lower the confidence 
# level or provide a wider range to reflect your uncertainty.

# """

# prompt_range_prediction = """
# {task_desc}

# The two attributes are 

# - X: "{attr1}"
# - Y: "{attr2}"

# They are from the table: "{table}". The description for the table and the attributes are as follows:

# {tbl_desc}

# Respond with your predictions in the following format:

# ```json
# {{
#   "coefficient": "<predicted correlation coefficient>",
#   "lower_bound": "<predicted lower bound>",
#   "upper_bound": "<predicted upper bound>",
#   "confidence_level": "<confidence level in float number>"
# }}
# ```
# """

prompt_range_prediction = """
<Task>:
{task_desc}

<Attributes>
- "{attr1}"
- "{attr2}"

<Source Table>: "{table}"

<Descriptions>:
- Dataset Description: {tbl_desc}
- Attribute Descriptions:
    - "{attr1}": {var1_desc}
    - "{attr2}": {var2_desc}

Respond with your predictions in the following format:

```json
{{
  "coefficient": "<predicted correlation coefficient>",
  "lower_bound": "<predicted lower bound>",
  "upper_bound": "<predicted upper bound>",
  "confidence_level": "<confidence level in float number>"
}}
```
"""