class Variable:
    def __init__(self, attr: str, table: str, table_desc: str, var_desc: str):
        self.attr = attr
        self.table = table
        self.table_desc = table_desc
        self.var_desc = var_desc

    def __repr__(self):
        return f"Variable(attr={self.attr}, attr_desc={self.var_desc} table={self.table}, table_desc={self.table_desc})"


class Correlation:
    def __init__(self, var1: Variable, var2: Variable, join_key: str = "", granu: str = "", new_context: str = ""):
        self.var1 = var1
        self.var2 = var2
        self.join_key = join_key
        self.granu = granu
        self.new_context = new_context
        
    def get_msg(self, msg):
        return msg.format(
            attr1=self.var1.attr,
            table1=self.var1.table,
            attr2=self.var2.attr,
            table2=self.var2.table,
            join_key=self.join_key,
            granu=self.granu
        )