import resource
import contextlib
import signal
import multiprocessing
import multiprocessing.pool
import functools
import time
import os
import signal
import sys
import psutil


def timeout(max_timeout):
    """Timeout decorator, parameter in seconds."""
    def timeout_decorator(item):
        """Wrap the original function."""
        @functools.wraps(item)
        def func_wrapper(*args, **kwargs):
            """Closure for function."""
            pool = multiprocessing.pool.ThreadPool(processes=1)
            async_result = pool.apply_async(item, args, kwargs)
            # raises a TimeoutError if execution exceeds max_timeout

            try:
                res = async_result.get(max_timeout)
            except Exception as e:
                res = e
            finally:
                pool.close()
            return res

        return func_wrapper
    return timeout_decorator


@contextlib.contextmanager
def time_limit(seconds: float):
    def signal_handler(signum, frame):
        raise TimeoutException("Timed out!")
    signal.setitimer(signal.ITIMER_REAL, seconds)

    signal.signal(signal.SIGALRM, signal_handler)
    try:
        yield
    finally:
        signal.setitimer(signal.ITIMER_REAL, 0)


class TimeoutException(Exception):
    pass


def test():
    def power(a: int, b: int) -> int:
        try:
            if b == 0:
                return 1
            else:
                return a * a * power(a, b - 2)
        except Exception:
            return "Failure"

    assert power(5, 5) == 3125

# Signal 0 - means to start a timer
# Signal 1 - means done


def timer(conn, time_limit):

    should_time = False
    start_time = 0
    # continually running
    while True:
        if should_time and time.time() - start_time > time_limit:
            should_time = False
            conn.send(1)

        signal = conn.recv()
        if signal == 0:
            should_time = True
            start_time = time.time()

            # update every 0.01 seconds


parent_conn, child_conn = multiprocessing.Pipe()


# with time_limit(1):
#     test()


prog = '''
def power(a: int, b: int) -> int:
    """
    Write a function to calculate the value of 'a' to the power 'b'.
    """
    try:
        if b == 0:
            return 1
        else:
            return a * a * power(a, b - 2)
    except Exception:
        return "Kindly enter numbers only"

result = power(2, 5)
print(result)

assert power(5, 5) == 3125'''

# prog = '''prsint('hi!')'''


def test_test():
    print("DA")
    with time_limit(0.1):
        test()
    print("Done")


# p = multiprocessing.Process(target=test_test, daemon=True)

# p.start()

# while True:
#     print("running")
#     time.sleep(0.1)


def t1():
    print("Ha")
    raise ValueError()
    while True:
        print("A")


def t2():
    while True:
        print("B")


# print("A")
# try:
#     p = multiprocessing.Process(
#         target=t1)
#     p.start()
#     print("Da")
# except:
#     print("Wrong")


def check_if_still_alive(process, timelimit, starting_time):
    while True:
        # if process.is_alive():
        if time.time() - starting_time >= timelimit:
            process.kill()
            return
        time.sleep(0.01)


def timeout_exec_program(program, globals_dict, timelimit):

    # def run_func(q, func_to_run, *args):
    #     try:
    #         queue.put((True, func_to_run(*args)))
    #     except Exception as e:
    #         queue.put((False, type(e).__name__))

    # queue = multiprocessing.Queue(1)

    # args_to_exec = (queue, exec, program, globals_dict)

    p = multiprocessing.Process(
        target=exec, args=(program, globals_dict), daemon=True)

    # checker = multiprocessing.Process(
    #     target=check_if_still_alive, args=(p, timelimit, time.time()), daemon=True)
    p.start()

    p.join(timeout=1)
    if p.is_alive():
        p.kill()
    # checker.start()

    # checker.join()
    print("Done")


timeout_exec_program(prog, {}, 1)

# test()


class _Timeout_Exec(object):

    """Wrap a function and add a timeout (limit) attribute to it.
    Instances of this class are automatically generated by the add_timeout
    function defined above. Wrapping a function allows asynchronous calls
    to be made and termination of execution after a timeout has passed.
    """

    def __init__(self, limit):
        """Initialize instance in preparation for being called."""
        self.__limit = limit
        self.__function = exec
        self.__timeout = time.time()
        self.__process = multiprocessing.Process()
        self.__queue = multiprocessing.Queue()

    def _target(self, queue, function, program, globals_dict):
        """Run a function with arguments and return output via a queue.
        This is a helper function for the Process created in _Timeout. It runs
        the function with positional arguments and keyword arguments and then
        returns the function's output by way of a queue. If an exception gets
        raised, it is returned to _Timeout to be raised by the value property.
        """
        try:
            queue.put((True, exec(program, globals_dict)))
        except Exception as e:
            queue.put((False, e))

    def __call__(self, program, globals_dict):
        """Execute the embedded function object asynchronously.
        The function given to the constructor is transparently called and
        requires that "ready" be intermittently polled. If and when it is
        True, the "value" property may then be checked for returned data.
        """
        self.__queue = multiprocessing.Queue(1)
        args = (self.__queue, self.__function, program, globals_dict)
        self.__process = multiprocessing.Process(target=self._target,
                                                 args=args)
        self.__process.daemon = True
        self.__process.start()

        self.__timeout = time.time() + self.__limit

        while not self.ready:
            time.sleep(0.01)
        return self.value

    def cancel(self):
        """Terminate any possible execution of the embedded function."""
        while self.__process.is_alive():
            self.__process.terminate()
            self.__process.join(0.1)

        raise TimeoutError()

    @property
    def ready(self):
        """Read-only property indicating status of "value" property."""
        if self.__limit and self.__timeout < time.time():
            self.cancel()
        return self.__queue.full() and not self.__queue.empty()

    @property
    def value(self):
        """Read-only property containing data returned from function."""
        if self.ready is True:
            flag, load = self.__queue.get()
            if flag:
                return load
            raise load


# timeout_class = _Timeout_Exec(0.1)

# timeout_class(prog, {})
