import json
import pandas as pd


def process_humaneval():
    '''
    Processing HumanEval database.


    Returns a list of dictionaries, each with the following keys:
    task_id
    prompt
    entry_point -> function name
    canoical_solution -> solution
    test -> assert cases in the form of a function called 'check' to be called with the function name
    passed as a parameter
    '''

    humaneval_list = []
    with open("HumanEval.jsonl", "r") as humaneval_dataset:
        for one_problem in humaneval_dataset:
            problem_dict = json.loads(one_problem)

            humaneval_list.append(problem_dict)

    return humaneval_list


def humaneval_to_csv():
    humaneval_list = process_humaneval()

    humaneval_df = pd.DataFrame(humaneval_list)
    humaneval_df.to_csv('humaneval.csv')
