# MBPP
def gen_test_cases_without_example_assertion_format(prompt, func_name, signature, *args):
    '''
    Generates format to send to Codex to generate test cases.
    '''

    format = f'''# Python 3
# {prompt}

def {signature}:
    pass # To-do: Implement

# Check if {func_name} works

assert {func_name}('''

    return format,  f"assert {func_name}("


def gen_test_cases_using_example_assertion_format(prompt, func_name, signature, assertion_cases, *args):
    '''
    Generates format to send to Codex to generate test cases. Has an example assertion statement.
    '''
    format = f'''# Python 3
# {prompt}

def {signature}:
    pass # To-do: Implement

# Check if {func_name} works

{assertion_cases[0]}
assert {func_name}('''

    return format,  f"assert {func_name}("


def gen_test_cases_return_type_detailed_param_type(prompt, func_name, signature, assertion_cases, params, param_typing, return_type, *args):
    '''
    Generates format to send to Codex to generate test cases.

    In a format similar to HumanEval cases
    made by JT (who I assume is the coauthor to the Codex paper). Includes return type and parameter types.

    Ex of HumanEval prompt:
    from typing import List


    def below_zero(operations: List[int]) -> bool:
        """ You're given a list of deposit and withdrawal operations on a bank account that starts with
        zero balance. Your task is to detect if at any point the balance of account fallls below zero, and
        at that point function should return True. Otherwise it should return False.
        >>> below_zero([1, 2, 3])
        False
        >>> below_zero([1, 2, -4, 5])
        True
        """
    '''

    parameter_format = [f"{a} : {b}" for a, b in zip(params, param_typing)]

    format = \
        f'''def {func_name}({", ".join(parameter_format)}) -> {return_type}:
    """
    {prompt}
    """
    pass # To-do: implement

# Check if {func_name} works
assert {func_name}('''

    return format, f"assert {func_name}("


def gen_test_cases_without_signature(prompt, *args):
    '''
    Generates format to send to Codex to generate test cases. Has no signature; only prompt and function name
    is passed to Codex.
    '''
    format = f'''"""
Python 3
{prompt}
"""

assert'''

    return format, f"assert"


def gen_test_cases_using_param_typing(prompt, func_name, signature, assertion_cases, params, param_typing, *args):
    '''
    Generates format to send to Codex to generate test cases. Includes function name and parameter types.
    '''

    parameter_format = [f"{a} : {b}" for a, b in zip(params, param_typing)]

    format = f'''"""
Python 3
{prompt}
"""

def {func_name}({", ".join(parameter_format)}):
    pass # To-do: implement

# Check if {func_name} works
assert'''
    print(format)

    return format, f"assert"


# Humaneval

def humaneval_testcase_formatting(prompt, func_name, *args):
    '''
    HumanEval program formatting for submission to Codex to generate test cases.
    '''

    format = f'''{prompt}
    pass

assert {func_name}('''

    return format, f'''assert {func_name}('''
