# MBPP

def gen_program_return_type_detailed_param_type(prompt, func_name, assertion_cases, params, param_typing, return_type):
    '''
    Generates format to send to Codex to generate programs. Includes function name and parameter types.

    In a format similar to HumanEval cases
    made by JT (who I assume is the coauthor to the Codex paper). Includes return type and parameter types.

    Ex of HumanEval prompt:
    from typing import List


    def below_zero(operations: List[int]) -> bool:
        """ You're given a list of deposit and withdrawal operations on a bank account that starts with
        zero balance. Your task is to detect if at any point the balance of account fallls below zero, and
        at that point function should return True. Otherwise it should return False.
        >>> below_zero([1, 2, 3])
        False
        >>> below_zero([1, 2, -4, 5])
        True
        """
    '''

    parameter_format = [f"{a} : {b}" for a, b in zip(params, param_typing)]

    format = \
        f'''def {func_name}({", ".join(parameter_format)}) -> {return_type}:
    """
    {prompt}
    """'''

    return format


def gen_program_using_example_assertion_format(prompt, func_name, assertion_cases, *args):
    '''
    Generates format to send to Codex to generate programs.
    '''

    format = f'''# Python 3
# {prompt}

{assertion_cases[0]}

def {func_name}('''

    return format


def gen_program_using_param_typing(prompt, func_name, assertion_cases, params, param_typing):
    '''
    Generates format to send to Codex to generate programs. Includes function name and parameter types.
    '''

    parameter_format = [f"{a} : {b}" for a, b in zip(params, param_typing)]

    format = f'''"""
Python 3
{prompt}
"""

def {func_name}({", ".join(parameter_format)})'''

    print(format)

    return format


def gen_program_without_assertion_format(prompt, func_name, *args):
    '''
    Generates format to send to Codex to generate programs. Doesn't have an example assertion format.
    '''

    format = f'''"""
Python 3
{prompt}
"""

def {func_name}('''

    return format


def gen_program_without_func_name(prompt, *args):
    '''
    Generates format to send to Codex to generate programs. Doesn't include function name.
    '''

    format = f'''"""
Python 3
{prompt}
"""

def'''

    return format


# Humaneval
def humaneval_program_formatting(prompt, *args):
    '''
    Formatting HumanEval for program prompting to be in line with my code.
    '''

    return prompt
