import numpy as np
import math
import os
import json
import torch


def dense_to_one_hot(y, max_value=9, min_value=0):
    """
    converts y into one hot reprsentation.
    Parameters
    ----------
    y : list
        A list containing continous integer values.
    Returns
    -------
    one_hot : numpy.ndarray
        A numpy.ndarray object, which is one-hot representation of y.
    """
    length = len(y)
    one_hot = np.zeros((length, (max_value - min_value + 1)))
    one_hot[list(range(length)), y] = 1
    return one_hot


def validateJSON(jsonData):
    try:
        json.loads(jsonData)
    except ValueError as err:
        return False
    return True
