class Parser:
    def __init__(self, config):
        self._config_args = config

    @property
    def experiment_args(self):
        return self._config_args["Experiment"]

    @property
    def data_args(self):
        return self._config_args["Data"]

    @property
    def model_args(self):
        return self._config_args["Model"]

    @property
    def pretrain_args(self):
        return self._config_args["Pretrain"]

    @property
    def compression_args(self):
        return self._config_args["Compression"]

    def parse(self):
        return (
            self.experiment_args,
            self.data_args,
            self.model_args,
            self.pretrain_args,
            self.compression_args,
        )
