"""
Various utilities that don't fit anwhere else.
"""

from itertools import zip_longest, islice
import os
import importlib
import logging
import pkgutil
import random
import resource
import subprocess
import sys

import torch
import numpy

from lang_exps.common.tee_logger import TeeLogger

logger = logging.getLogger(__name__)  # pylint: disable=invalid-name


def prepare_global_logging(
    args,
    file_friendly_logging=False,
    stdout_file_name="stdout.log",
    stderr_file_name="stderr.log",
):
    """
    Parameters
    ----------
    output_dir
        The directory to stream logs to.
    file_friendly_logging
        Whether logs should clean the output to prevent carridge returns
        (used to update progress bars on a single terminal line).
    """
    # tqdm.set_slower_interval(file_friendly_logging)

    std_out_file = os.path.join(args.output_dir, stdout_file_name)
    sys.stdout = TeeLogger(
        std_out_file, sys.stdout, file_friendly_logging  # type: ignore
    )
    sys.stderr = TeeLogger(
        os.path.join(args.output_dir, stderr_file_name),  # type: ignore
        sys.stderr,
        file_friendly_logging,
    )

    stdout_handler = logging.FileHandler(std_out_file)

    logging.basicConfig(
        format="%(asctime)s - %(levelname)s - %(name)s -   %(message)s",
        datefmt="%m/%d/%Y %H:%M:%S",
        level=logging.INFO if args.local_rank in [-1, 0] else logging.WARN,
    )
    logging.getLogger().addHandler(stdout_handler)
