#!/usr/bin/env bash

PARENT_DATA_DIR="./data"
DATA_DIR="$PARENT_DATA_DIR/other_data"
if [ -d $DATA_DIR ]; then
   echo "The directory '$DATA_DIR' exists."
else
   echo "Creating the directory '$DATA_DIR'."
   mkdir $DATA_DIR
fi

CURRENT_DIR=$PWD
echo "Current working directory '$CURRENT_DIR'"
cd $DATA_DIR

id="Dbh9Qhbd2JNdDBsQUdocVU"
gdown https://drive.google.com/uc?id=0Bz8a_$id

filename="yahoo_answers_csv"
splitdir="split_yahoo_answers_csv"
mkdir $splitdir

tar -zxf $filename.tar.gz -C $splitdir --strip-components 1

rm $filename.tar.gz

cd $CURRENT_DIR

python -m lang_exps.data.process_raw_data --task "splityahooqa" --data_dir $PARENT_DATA_DIR --mode "processed" --n_dev_examples 5999 --n_test_examples 60000