#!/usr/bin/env bash
. activate lll-nlp

CUDA_DEVICE=${1}

DATA_DIR=${2}
OUTPUT_DIR=${3}
TASK_NAMES=${4}

MODEL_TYPE=${5}
MODEL_NAME=${6}

METHOD=${7}

PT=${8}

CACHE_DIR=${9}

OPTIMIZER=${10}

RHO=${11}

OTHER_ARGS=${12}

REPLAY_RATE=1.0
WRITE_RATE=0.01
MAX_EXAMPLES_PER_CLASS=1

if [[ $METHOD = 'er' ]]
then
    SPARSE_REPLAY='yes'
else
    SPARSE_REPLAY='no'
fi

LMBDA=100.0
GAMMA=0.9

if [[ $METHOD = 'ewc' ]]
then
    METHOD_ARGS='--ewc'
else
    METHOD_ARGS=''
fi


if [[ $PT = 'pt' ]]
then
    PT_FLAG='none'
elif [[ $PT = 'xyz_init' ]]
then
    PT_FLAG='xyz_init'
else
    PT_FLAG='rndm_init'
fi


N_EPOCHS=1
LR=2e-05
#LR=2e-04

#BATCH_SIZE=8
BATCH_SIZE=32
EVAL_BATCH_SIZE=64
MAX_SEQ_LENGTH=128

WRITING_STRATEGY="random"

SEED=42

for TASK_NAME in $TASK_NAMES;
do
    echo ${TASK_NAME}
    echo ${SPARSE_REPLAY}
    echo ${METHOD_ARGS}
    echo ${OTHER_ARGS}

    CUDA_VISIBLE_DEVICES=${CUDA_DEVICE} python -m lang_exps.main_text \
        --model_name_or_path ${MODEL_NAME} \
        --model_type ${MODEL_TYPE} \
        --task_name ${TASK_NAME} \
        --do_train \
        --do_val \
        --do_eval \
        --data_dir ${DATA_DIR} \
        --max_seq_length ${MAX_SEQ_LENGTH} \
        --per_gpu_eval_batch_size=${EVAL_BATCH_SIZE}   \
        --per_gpu_train_batch_size=${BATCH_SIZE}   \
        --learning_rate ${LR} \
        --num_train_epochs ${N_EPOCHS} \
        --save_steps 750000 \
        --output_dir ${OUTPUT_DIR} \
        --replay_rate ${REPLAY_RATE} \
        --write_rate ${WRITE_RATE} \
        --sparse_replay ${SPARSE_REPLAY} \
        --write_strategy ${WRITING_STRATEGY} \
        --cache_dir ${CACHE_DIR} \
        --processed_data \
        --max_examples_per_class ${MAX_EXAMPLES_PER_CLASS} \
        --logging_steps 1000 \
        --logging_first_step \
        --evaluate_during_training \
        --model_type2 ${PT_FLAG} \
        --replay_tiny \
        --lmbda ${LMBDA} \
        --gamma ${GAMMA} \
        --seed ${SEED} \
        --optimizer ${OPTIMIZER} \
        --rho ${RHO} \
        ${METHOD_ARGS} ${OTHER_ARGS}
done
