# Demo Video Collection

This repository contains face swapping demonstration videos for method comparison and evaluation.

## 📁 Structure

```
demo_video/
├── 1source_differ_id.mp4           # One source video with multiple target identities
├── dynamic_compare_concat.mp4       # Comparison with DynamicFace
├── hifi_compare_concat.mp4         # Comparison with HifiVFS
├── long_video_result.mp4           # Extended duration results
├── 1id_differ_source/              # One target face, different sources video
│   ├── 122389.mp4
│   ├── 2790140.mp4
│   └── 4974438.mp4
└── compare_differ_method/           # Method comparison per test case
    ├── 122389.mp4
    ├── 210574.mp4
    ├── 2790140.mp4
    ├── 44646.mp4
    └── 4974438.mp4
```

## 🎬 Videos

### Main Directory
- **`1source_differ_id.mp4`**: Shows one source video with multiple different target faces
- **`dynamic_compare_concat.mp4`**: Comparison with DynamicFace
- **`hifi_compare_concat.mp4`**: Comparison with HifiVFS
- **`long_video_result.mp4`**: Extended sequences for temporal consistency evaluation

### Subdirectories

#### `1id_differ_source/`
Videos showing one target identity applied to different source videos. 

#### `compare_differ_method/`
Method comparison videos for each test case. 

## 🔍 Evaluation Focus
- **Identity Preservation**: Target face consistency
- **Expression Transfer**: Source expression accuracy  
- **Visual Quality**: Artifacts and realism
- **Temporal Stability**: Frame-to-frame consistency

---

*Test case IDs (122389, 210574, etc.) represent specific face swap
