from .models import PixelNeRFNet, PixelNeSFNet, PixelUNISURFNet


def make_model(conf, *args, **kwargs):
    """ Placeholder to allow more model types """
    # print(conf)
    model_type = conf.get_string("type", "pixelnerf")  # single
    # print(model_type)
    if model_type == "pixelnerf":
        net = PixelNeRFNet(conf, *args, **kwargs)
    elif model_type == "pixelnesf":
        net = PixelNeSFNet(conf, *args, **kwargs)
    elif model_type == "pixelunisurf":
        net = PixelUNISURFNet(conf, *args, **kwargs)
    else:
        raise NotImplementedError("Unsupported model type", model_type)
    return net
