# Self-supervised Graph-level Representation Learning with Local and Global Structure

## Introduction

This project is an implementation of ``Self-supervised Graph-level Representation Learning with Local and Global Structure'' in PyTorch. 
We provide the pre-training and fine-tuning codes for chemistry and biology domains. 

### Prerequisites

We develop this project with `Python3.6` and  following Python packages:

```
Pytorch                   1.1.0
torch-cluster             1.4.5                    
torch-geometric           1.0.3                    
torch-scatter             1.4.0                    
torch-sparse              0.4.4                    
torch-spline-conv         1.0.6 
rdkit                     2019.03.1
```
**P.S.** In our project, these packages can be successfully installed and work together under `CUDA/9.0` and `cuDNN/7.0.5`.

### Dataset Preparation

In the folder of corresponding domain, *i.e.* `./chemistry/` or `./biology/`, create a folder for datasets:

```
cd GraphLoG && cd chemistry (cd biology) && mkdir dataset
```

The datasets for these two domains can be downloaded from [the project page](http://snap.stanford.edu/gnn-pretrain) of a previous work.

## Pre-training

To pre-train on chemistry domain with the proposed ***GraphLoG*** method, simply run:
```
python pretrain_graphlog_chem.py --output_model_file $self-supervised_model$
```

To pre-train on biology domain with the proposed ***GraphLoG*** method, simply run:
```
python pretrain_graphlog_bio.py --output_model_file $self-supervised_model$
```

For the subsequent supervised pre-training, simply run:
```
python pretrain_supervised.py --input_model_file $self-supervised_model$ \
                              --output_model_file $supervised_model$
```

## Fine-tuning
To fine-tune on a downstream task, simply run:
```
python finetune.py --input_model_file $pre-trained_model$ \
                   --dataset $downstream_dataset$
```

### Pretrained Model

For both domains, we provide the GIN model pre-trained by GraphLoG at `./chemistry/pretrain_model/` and `./biology/pretrain_model/`.