# Dataset Code Appendix

This folder contains code for generating synthetic datasets with different physical properties using Genesis simulation framework.

## Environment Setup

Before running the code, you need to set up the required environment using the provided YAML configuration file:

```bash
conda env create -f environment_genesis.yaml
conda activate genesis
```

This will install all necessary dependencies and packages required for the Genesis simulation environment. You can also see the libraries we used and the version of them in the .yaml file.

## Usage

The folder includes three Python scripts that generate synthetic datasets for different physical properties (taking the $A_1$ domain as an example):

### 1. Elasticity Dataset
```bash
python elasticity.py
```


### 2. Friction Dataset
```bash
python friction.py
```


### 3. Viscosity Dataset
```bash
python viscosity.py
```


