#!/bin/bash

DATASET_ROOT=$HOME"/workspaces/jointist/datasets"

hdfs dfs -copyToLocal hdfs://haruna/home/byte_speech_sv/projects/jointist/download/groove $DATASET_ROOT
# Now, there are three files:
# - $HOME"/workspaces/jointist/datasets/groove/e-gmd-v1.0.0.zip"
# - $HOME"/workspaces/jointist/datasets/groove/e-gmd-v1.0.0-midi.zip"
# - $HOME"/workspaces/jointist/datasets/groove/e-gmd-v1.0.0.csv"
cd $DATASET_ROOT"/groove"

# Since `e-gmd-v1.0.0.zip` has all audio/midi/csv, you don't need to unzip the midi one.
unzip "e-gmd-v1.0.0.zip"
# Now, we have
# `$HOME"/workspaces/jointist/datasets/groove/e-gmd-v1.0.0/drummer*` folders, which have audio and midi.
# as well as `$HOME"/workspaces/jointist/datasets/groove/e-gmd-v1.0.0/e-gmd-v1.0.0.csv`.
