#!/bin/bash

WORKSPACE=$HOME"/workspaces/jointist"
PATH_DATASET=$WORKSPACE"/datasets/groove/e-gmd-v1.0.0"

# Users can modify the following config setting.
StringArray="config_1 config_2 config_3"

for CONFIG_TYPE in $StringArray; do
  # Directory of processed MIDI files.
  PATH_DATASET_PROCESSED="${WORKSPACE}/datasets/groove_processed/${CONFIG_TYPE}"
  mkdir -p $PATH_DATASET_PROCESSED

  # Prepare closed set and write out prepared MIDI files.
  python3 jointist/dataset_creation/groove_prepare_midi.py \
      --config_type=$CONFIG_TYPE \
      --path_dataset=$PATH_DATASET \
      --path_dataset_processed=$PATH_DATASET_PROCESSED
done
