#!/bin/bash

PROJ_DIR=$(pwd)

WORKSPACE=${1:-./workspaces}
HARU_NAME=${2:-haruna}  # haruna or harunava

HDFS_VOCAL_SEGMENTS="hdfs://"$HARU_NAME"/home/byte_speech_sv/data/download/mixing_secrets/mixing_secrets_vocal_stems_16k_segmented.zip"
HDFS_VOCAL_LABELS="hdfs://"$HARU_NAME"/home/byte_speech_sv/data/download/mixing_secrets/mixing_secrets_vocal_stems_16k_segmented-pitch_estimation.zip"

JOINTIST_PATH=$WORKSPACE"/jointist"

hdfs dfs -copyToLocal $HDFS_VOCAL_SEGMENTS $JOINTIST_PATH"/"
hdfs dfs -copyToLocal $HDFS_VOCAL_LABELS $JOINTIST_PATH"/"

unzip $JOINTIST_PATH"/mixing_secrets_vocal_stems_16k_segmented.zip" -d $JOINTIST_PATH"/mixing_secrets_vocal_stems_16k_segmented"
unzip $JOINTIST_PATH"/mixing_secrets_vocal_stems_16k_segmented-pitch_estimation.zip" -d $JOINTIST_PATH"/mixing_secrets_vocal_stems_16k_segmented-pitch_estimation"
