#!/bin/bash

# Users can modify the following config file.
CONFIG_YAML="scripts/configs/train/config_4_piano.yaml"

# Users can modify the following path.
CHECKPOINT_PATH="/home/tiger/workspaces/jointist/checkpoints/train_openset/config=config_4_piano,gpus=1/step=180000.pth"

CUDA_VISIBLE_DEVICES=0 python3 jointist/inference.py \
    --config_yaml=$CONFIG_YAML \
    --checkpoint_path=$CHECKPOINT_PATH \
    --audio_path="resources/Mojito.mp3" \
    --cuda


####
INSTRUMENTS_CLASSIFICATION_CONFIG_YAML="scripts/configs/train_instruments_classification/cnn14.yaml"

INSTRUMENTS_CLASSIFICATION_CHECKPOINT_PATH="/home/tiger/workspaces/jointist/checkpoints/train_instruments_classification/config=cnn14,gpus=1/step=180000.pth"

CUDA_VISIBLE_DEVICES=0 python3 jointist/inference_instruments_classification.py inference_probs \
    --config_yaml=$INSTRUMENTS_CLASSIFICATION_CONFIG_YAML \
    --checkpoint_path=$INSTRUMENTS_CLASSIFICATION_CHECKPOINT_PATH \
    --audio_path="resources/Mojito_acc.wav" \
    --midi_path="results/Mojito_acc.mid" \
    --cuda

python3 jointist/inference_instruments_classification.py cluster \