#!/bin/bash
# The first argument is Slakh2100 dataset directory (optional).
# The second argument is workspace directory (optional).

SLAKH_DATASET_DIR=${1:-"./datasets/slakh2100/slakh2100_flac"}    # Default dataset directory
WORKSPACE=${2:-"./workspaces/jointist"}     # Default workspace directory


WAVEFORM_HDF5S_DIR=$WORKSPACE"/hdf5s/waveforms"
mkdir $SLAKH_DATASET_DIR -p
mkdir $WAVEFORM_HDF5S_DIR -p

# Pack audio files into hdf5 files.
python3 jointist/dataset_creation/create_slakh2100.py pack_audios_to_hdf5s \
    --audios_dir=$SLAKH_DATASET_DIR \
    --hdf5s_dir=$WAVEFORM_HDF5S_DIR