#!/bin/bash

DOWNLOAD_PATH=$HOME"/download/groove"
mkdir -p $DOWNLOAD_PATH

wget https://storage.googleapis.com/magentadata/datasets/e-gmd/v1.0.0/e-gmd-v1.0.0-midi.zip -O $DOWNLOAD_PATH"/e-gmd-v1.0.0-midi.zip"
wget https://storage.googleapis.com/magentadata/datasets/e-gmd/v1.0.0/e-gmd-v1.0.0.csv -O $DOWNLOAD_PATH"/e-gmd-v1.0.0.csv"
wget https://storage.googleapis.com/magentadata/datasets/e-gmd/v1.0.0/e-gmd-v1.0.0.zip -O $DOWNLOAD_PATH"/e-gmd-v1.0.0.zip"

# copy to hdfs
hdfs dfs -mkdir -p hdfs://haruna/home/byte_speech_sv/projects/jointist/download
hdfs dfs -copyFromLocal $DOWNLOAD_PATH hdfs://haruna/home/byte_speech_sv/projects/jointist/download

# now there are
# {audio, midi, csv}: `hdfs://haruna/home/byte_speech_sv/projects/jointist/download/groove/e-gmd-v1.0.0.zip`
# midi only: `hdfs://haruna/home/byte_speech_sv/projects/jointist/download/groove/e-gmd-v1.0.0-midi.zip`
# csv only: `hdfs://haruna/home/byte_speech_sv/projects/jointist/download/groove/e-gmd-v1.0.0.csv`
