#!/bin/bash

DS_PATH=$HOME"/workspaces/jointist/datasets/"

# Set up paths
mkdir -p $DS_PATH

# Download dataset from HDFS
hdfs dfs -copyToLocal \
  hdfs://haruna/home/byte_speech_sv/projects/jointist/dataset_processed/groove/groove_h5s-midi_events-config123.zip \
  $DS_PATH

hdfs dfs -copyToLocal \
  hdfs://haruna/home/byte_speech_sv/projects/jointist/dataset_processed/groove/groove_h5s-waveforms.zip \
  $DS_PATH

# Unzip dataset
cd $DS_PATH
unzip "groove_h5s-midi_events-config123.zip"
unzip "groove_h5s-waveforms.zip"

# Now $DS_PATH has a folder: `groove_h5s`, which has two folders: 'midi_events/', 'waveforms/'.
# You can start training a drum transcription model using these.
