#!/bin/bash

PROJ_DIR=$(pwd)

HARU_NAME=${1:-haruna}  # haruna or harunava
MY_HDFS_MIXING_SECRETS_DIR="hdfs://"$HARU_NAME"/home/byte_speech_sv/data/download/mixing_secrets"
MY_HDFS_MIXING_SECRETS_VOCALS="hdfs://"$HARU_NAME"/home/byte_speech_sv/data/download/mixing_secrets/mixing_secrets_452tracks.zip"
hdfs dfs -mkdir $MY_HDFS_MIXING_SECRETS_DIR


SOURCE_PATH=$HOME"/download/"
STEMS_PATH=$HOME"/mixing_secrets_vocal_stems"

cd $HOME
git clone https://github.com/keunwoochoi/mixing_secrets.git

python3 mixing_secrets/unzip_vocals_only.py --source_path $SOURCE_PATH --target_path $STEMS_PATH
# now we have 2,471 wave files in the target path.
chmod 755 $STEMS_PATH
chmod 755 $STEMS_PATH/*.wav

# segment by silence
cd $HOME
SEGMENTS_PATH=$HOME"/mixing_secrets_vocal_stems_16k_segmented"
mkdir -p $SEGMENTS_PATH

pip install auditok

cd $PROJ_DIR
python3 jointist/dataset_creation/mixing_secrets/segment_vocal_stems.py \
  --source_path $STEMS_PATH \
  --target_path $SEGMENTS_PATH

# now there are many (max) 10-second wav files at $SEGMENTS_PATH.
# let's zip all this wav files and move it to HDFS.
cd $SEGMENTS_PATH
zip -0 "mixing_secrets_vocal_stems_16k_segmented.zip" *.wav
hdfs dfs -copyFromLocal "mixing_secrets_vocal_stems_16k_segmented.zip" $MY_HDFS_MIXING_SECRETS_DIR"/"

# save pitch predictions
pip install crepe
pip install tensorflow
cd $SEGMENTS_PATH
cd ..
CUDA_VISIBLE_DEVICES=0 crepe mixing_secrets_vocal_stems_16k_segmented --save-activation --viterbi

cd $SEGMENTS_PATH
zip -0 "mixing_secrets_vocal_stems_16k_segmented-pitch_estimation.zip" *.npy
hdfs dfs -copyFromLocal "mixing_secrets_vocal_stems_16k_segmented-pitch_estimation.zip" $MY_HDFS_MIXING_SECRETS_DIR"/"
