#!/bin/bash
# The first argument is workspace directory (optional).
if [ $# -eq 0 ]; then
    WORKSPACE="./workspaces/jointist"    # Default workspace directory
elif [ $# -eq 1 ]; then
    WORKSPACE=$1
fi

# Users can modify the following config file.
CONFIG_YAML="scripts/configs/train/regression_onset_offset_frame.yaml"

# Users can modify the following path.
CHECKPOINT_PATH="pretrained_models/regression_onset_offset_frame_5_instruments_60000_steps.pth"

CUDA_VISIBLE_DEVICES=2 python3 jointist/evaluate.py \
    --workspace=$WORKSPACE \
    --config_yaml=$CONFIG_YAML \
    --checkpoint_path=$CHECKPOINT_PATH \
    --cuda
