#!/bin/bash
# The first argument is processed MIDI directory (optional).

WORKSPACE=${1:-"./workspaces/jointist"}     # Default workspace directory

CONFIG_NAME="config_4"  # Piano + drums

PROCESSED_MIDIS_DIR=$WORKSPACE"/dataset_processed/closed_set_${CONFIG_NAME}"
MIDI_EVENTS_HDF5S_DIR=$WORKSPACE"/hdf5s/midi_events/closed_set_${CONFIG_NAME}"

mkdir $MIDI_EVENTS_HDF5S_DIR -p

# Pack MIDI events into hdf5 files.
python3 jointist/dataset_creation/create_slakh2100.py pack_midi_events_to_hdf5s \
    --processed_midis_dir=$PROCESSED_MIDIS_DIR \
    --hdf5s_dir=$MIDI_EVENTS_HDF5S_DIR
