#!/bin/bash
# The first argument is Slakh2100 dataset directory (optional).
# The second argument is workspace directory (optional).

SLAKH_DATASET_DIR=${1:-"./datasets/slakh2100/slakh2100_flac"}    # Default dataset directory
WORKSPACE=${2:-"./workspaces/jointist"}     # Default workspace directory

# Users can modify the following config setting.
CONFIG_NAME="config_4"  # Piano + drums

# Config csv path.
CONFIG_CSV_PATH="./jointist/dataset_creation/midi_track_group_${CONFIG_NAME}.csv"

# Directory of processed MIDI files.
PATH_DATASET_PROCESSED="${WORKSPACE}/dataset_processed/closed_set_${CONFIG_NAME}"

# Prepare closed set and write out prepared MIDI files.
python3 jointist/dataset_creation/prepare_closed_set.py \
    --config_type="plugin" \
    --config_csv_path=$CONFIG_CSV_PATH \
    --path_dataset=$SLAKH_DATASET_DIR \
    --path_dataset_processed=$PATH_DATASET_PROCESSED
